// Textures
#declare BoisClair =
texture {
	pigment {
		bozo
		color_map {
			[ 0.000000 rgb <0.000000, 0.000000, 0.000000> ]
			[ 0.500000 rgb <0.519997, 0.000015, 0.000015> ]
			[ 1.000000 rgb <0.579995, 0.347311, 0.098604> ]
		}
		warp {
			turbulence <0.0, 5, 0.0>	
		}
	}
	finish {
		ambient rgb <1, 1, 1>
		brilliance 1.0
		phong 1.0
		roughness 0.0005
	}
}

#declare BoisBlanc = 
texture {
	pigment {
		wood
		color_map {
			[ 0.000000 rgb <1.000000, 0.961669, 0.770001> ]
			[ 0.700000 rgb <1.000000, 0.617319, 0.180026> ]
			[ 1.000000 rgb <0.699992, 0.477852, 0.224018> ]
		}
		turbulence <0, 4, 0.0>
		omega 0.3
	}
}

#declare Tissu =
texture {
	pigment {
	waves
		color_map {
			[ 0.000 rgb <0.0, 0.0, 0.0> ]	//black
			[ 1.000 rgb <1.0, 1.0, 1.0> ]	//white
		}	
	}
	normal {
		waves
	}
	finish {
		ambient rgb <0.5, 0.5, 0.5>
		reflection {
			rgb <0.0, 0.0, 0.0>
		}
		diffuse 0.6
	}
}
// Fin des textures

// Objets

#declare Coin =
difference {
	torus {
		1.9, 0.5
		sturm
	}
	box {<0, -0.5, -2.4> <2.4, 0.5, 2.4>}
	box {<-2.4, -0.5, 0> <0.1, 0.5, 2.4>}
}

#declare Pied =
box {0 <1, 4, 1> texture {BoisBlanc scale 5}}

// Fin des objets

// Lit

#declare Lit =
union {

//Tte de lit
union {
	sphere_sweep {
		cubic_spline,
		6, 
		<0.0, -2, 0.0>, 0.5
		<0.0, -1, 0.0>, 0.5
		<0.0, 7, 0.0>, 0.5
		<13, 7, 0.0>, 0.5
		<13, -1, 0.0>, 0.5
		<13, -2, 0.0>, 0.5
	}
	
	sphere_sweep {
		cubic_spline,
		6, 
		<13, 5.5, 0.0>, 0.5
		<9, 7.5, 0.0>, 0.5
		<6.5, 4.5, 0.0>, 0.5
		<2, 4, 0.0>, 0.5
		<3.5, 7.5, 0.0>, 0.5
		<9, 7.5, 0.0>, 0.5
	}
	
	sphere_sweep {
		cubic_spline,
		4, 
		<3.5, 7, 0.0>, 0.5
		<6.5, 4.5, 0.0>, 0.5
		<13, 2.5, 0.0>, 0.5
		<17, 5, 0.0>, 0.5
	}
	
	sphere_sweep {
		linear_spline,
		2, 
		<0, 1.5, 0.0>, 0.5
		<13, 1.5, 0.0>, 0.5
	}
	
	translate z*-1
	translate y*1
	
	material {texture {BoisClair} scale 2}

} //Fin de la tte de lit

// matelas
superellipsoid {
	< 0.35, 0.35 >
	scale <13/2, 1, 17/2>
	translate <13/2, 1, -17/2>		
	texture {Tissu}
} // Fin du matelas

//Sommier

union {
	object {Coin rotate y*90 translate <2.15, 0, -2.15>}
	cylinder {
		<2.15, 0, -0.25>, <10.85, 0, -0.25>, 0.5
	}
	object {Coin rotate y*180 translate <10.85, 0, -2.15>}
	cylinder {
		<12.75, 0, -2.15>, <12.75, 0, -14.85>, 0.5
	}
	object {Coin rotate y*-90 translate <10.85, 0, -14.85>}
	cylinder {
		<2.15, 0, -0.25>, <10.85, 0, -0.25>, 0.5
		translate z*-16.5
	}
	object {Coin translate <2.15, 0, -14.85>}
	cylinder {
		<12.75, 0, -2.15>, <12.75, 0, -14.85>, 0.5
		translate x*-12.5
	}
	texture {BoisBlanc scale 5}
} // Fin du sommier

// Pieds

object {Pied translate <0, -4, -1>}
object {Pied translate <12, -4, -1>}
object {Pied translate <12, -4, -17>}
object {Pied translate <0, -4, -17>}
// Fin des pieds

} // Fin du lit